@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								{{ __('membership.list_title') }}
							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-end ">
									<form method="post" action="{{ route('membership.index') }}">
										{{ csrf_field() }}
										<div class="input-group mb-3">
											<input type="text" name="search" class="form-control"
												placeholder="{{ __('membership.search') }}" required>
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit"><i
														class="fas fa-search"></i></button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th class="nowrap">{{ __('membership.th_reg_no') }}</th>
													<th>{{ __('membership.th_name') }}</th>
													<th class="nowrap">{{ __('membership.th_membership_type') }}</th>
													<th class="nowrap">{{ __('membership.th_valid_from') }}</th>
													<th class="nowrap">{{ __('membership.th_valid_to') }}</th>
													<th class="nowrap">{{ __('membership.th_amount') }}</th>
													<th class="nowrap">{{ __('membership.th_paid') }}</th>
													<th class="nowrap">{{ __('membership.th_due') }}</th>
													<th class="nowrap">{{ __('membership.th_payment_status') }}</th>
													<th class="nowrap">{{ __('membership.th_membership_status') }}</th>
													<th class="fixed-width-td">{{ __('membership.th_action') }}</th>
												</tr>
											</thead>
											<tbody>
												@foreach($memberships as $membership)
												<tr>
													<td class="align-middle">
														{{ $membership->member->reg_no }}
													</td>
													<td class="align-middle nowrap">
														{{ $membership->member->name }}
													</td>
													<td class="align-middle nowrap">
														{{ $membership->membership_type->name }}
													</td>
													<td class="align-middle nowrap">
														{{ format_date($membership->valid_from) }}
													</td>
													<td class="align-middle nowrap">
														{{ format_date($membership->valid_to) }}
													</td>
													<td class="align-middle nowrap">
														{{ currency_symbol() }}
														{{ round_off($membership->membership_type->amount) }}
													</td>
													<td class="align-middle nowrap">
														{{ currency_symbol() }}
														{{ paid_amount($membership->transactions) }}
													</td>
													<td class="align-middle nowrap">
														{{ currency_symbol() }}
														{{ due_amount($membership->transactions) }}
													</td>
													<td class="align-middle nowrap">
														{!! transaction_status($membership->transactions) !!}
													</td>
													<td class="align-middle nowrap">
														{!! membership_status($membership->valid_to) !!}
													</td>
													<td>
														<div class="d-flex justify-content-end">
															@if(due_amount($membership->transactions) > 0)
															<a href="{{ route('transaction.create', $membership->id) }}"
																type="button" class="btn btn-success mr-2">
																<i class="fa fa-plus"></i>
															</a>
															@else
															<button type="button" class="btn btn-success mr-2" disabled>
																<i class="fa fa-plus"></i>
															</button>
															@endif

															<a href="{{ route('invoice.show', $membership->id) }}"
																type="button" class="btn btn-warning mr-2">
																<i class="fa fa-print"></i>
															</a>

															<form class="d-inline js-confirm-delete " method="POST"
																action="{{ route('membership.destroy', $membership->id) }}">
																{{ csrf_field() }}
																@method('DELETE')
																<button class="btn btn-primary">
																	<i class="fa fa-trash"></i>
																</button>
															</form>
														</div>
													</td>
												</tr>
												@endforeach
												@if(count($memberships) == 0)
												<tr>
													<td colspan="11">
														<p class="text-center mb-0">{{ __('membership.no_record_found')
															}}</p>
													</td>
												</tr>
												@endif
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										@if($paginate)
										{{ $memberships->links() }}
										@endif
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection